
//Light:
float4 lCol : COLOR <String uiname="Light Color";> = {0.5, 0.5, 0.5, 1};
float3 lPos <string uiname="Light Position";> = {0, 5, -2};       //light position in world space

//Object Material:
float4 colDiff  : COLOR <String uiname="Object Color";>  = {.8, .8, .8, 1};
float DiffAmount <String uiname="Diffuse Amount"; float uimin=0.0;> = 1;
float SpecAmount <String uiname="Specular Amount"; float uimin=0.0;> = .75;
float lPower <String uiname="Power"; float uimin=0.0;> = 25.0;     //shininess of specular highlight

//Ambient:
float4 colAmb  : COLOR <String uiname="Ambient Color";>  = {0.15, 0.15, 0.15, 1};
float gi <string uiname="Global Illumination Intensity";> =1;


float4 Directional_BlinnVSMspecular(	float4 PosW,
										float3 NormWV,
										float3 ViewDirWV,
										float3 LightDirWV,
										float2 TexCdShadow,
										float2 TexCd	)
{
	// Unnormalized light vector
    float3 dir_to_light = lPos - PosW;
	// distance from light
	float d = length(dir_to_light);
		
	// BLINN
    	float3 H = normalize(ViewDirWV + LightDirWV); //halfvector
    	float3 blinn = lit(dot(NormWV, LightDirWV), dot(NormWV, H), lPower);

	// DARK
    	float dark = 1;

	// SHADOWS
	float shadow = 1;
	if(shadowMult!=0)
		{
		float shadow = 1-(1-VSM_A(TexCdShadow, d)) * shadowMult; 
	   	dark = min(blinn.y, shadow);
		}
	else{	dark = blinn.y;	}
	
	// SPECULAR
    	//reflection vector (view space)
    	float3 R = normalize(2 * dot(NormWV, LightDirWV) * NormWV - LightDirWV);
    	//normalized view direction (view space)
    	float3 V = normalize(ViewDirWV);
    	//calculate specular light
    	float4 spec = pow(max(dot(R, V),0), lPower*.2) * dark * SpecAmount;
    		
	float4 FinalCol = (colDiff * tex2D(Samp, TexCd) * (dark + colAmb) + spec) * lCol * DiffAmount;
	FinalCol.a = 1;
	return FinalCol;
}
	